
// RecordTSDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RecordTS.h"
#include "RecordTSDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

BYTE * g_p_video_frame_buffer_background = NULL;

ULONG  g_n_video_frame_length_background = 0;

ULONGLONG g_n_src_video_sample_time = 0;

BYTE * g_p_audio_frame_buffer_background = NULL;

ULONG  g_n_audio_frame_length_background = 0;

ULONGLONG g_n_src_audio_sample_time = 0;

VOID DumpDebugMessage( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[DEBUG] ";
	
	va_list marker;

	va_start( marker, fmt);

	vsprintf( pszDebugDumpMessage + 8, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

DWORD WINAPI on_push_video_framebuffer( LPVOID params )
{
	CRecordTSDlg *  pMainDialog = (CRecordTSDlg *)(params);

	while ( TRUE && pMainDialog->m_bSetBuffer )
    {
		DWORD dwWaitResult = 0x00000000;

		dwWaitResult = WaitForSingleObject( pMainDialog->m_hVideoThreadBufferReadyEvent, INFINITE );		

		if( dwWaitResult == WAIT_OBJECT_0 )
		{
			if ( g_p_video_frame_buffer_background != NULL && g_n_video_frame_length_background > 0 )
			{
				BYTE * pStreamBuffer = NULL;

				ULONG  nStreamBufferLen = 0;

				BOOL   bIsKeyFrame = FALSE;

				ULONGLONG nDstPresentationTimeStamp = 0;

				ULONGLONG nDstDecodeTimeStamp = 0;

				AMESDK_CODEC_ENCODE( pMainDialog->m_hVideoSWEncoderDev, g_p_video_frame_buffer_background, PREVIEW_COLORSPACE,  WIDTH, HEIGHT, &pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame, FALSE,  g_n_src_video_sample_time, &nDstPresentationTimeStamp, &nDstDecodeTimeStamp );
		
				if(  bIsKeyFrame )
				{ 
					pMainDialog->m_nFileRendererRecordState = 0x00000002;
				}		

				if( ( pMainDialog->m_nFileRendererRecordState == 0x00000002 ) && ( nStreamBufferLen >  0 ) )
				{
					AMESDK_FILE_SET_VIDEO_STREAM_BUFFER( pMainDialog->m_hFileRendererDev, pStreamBuffer, nStreamBufferLen, bIsKeyFrame, 0, g_n_src_video_sample_time );
				}			
			}			
		}
	}

	return 0;
}

DWORD WINAPI on_push_audio_framebuffer( LPVOID params )
{
	CRecordTSDlg *  pMainDialog = (CRecordTSDlg *)(params);

	while ( TRUE && pMainDialog->m_bSetBuffer )
    {
		DWORD dwWaitResult = 0x00000000;

		dwWaitResult = WaitForSingleObject( pMainDialog->m_hAudioThreadBufferReadyEvent, INFINITE );		

		if( dwWaitResult == WAIT_OBJECT_0 )
		{
			if ( g_p_audio_frame_buffer_background != NULL && g_n_audio_frame_length_background > 0 )
			{
				ULONGLONG n_dst_sample_time = 0;

				BYTE * pStreamBuffer = NULL;

				ULONG  nStreamBufferSize = 0;

				AMESDK_CODEC_ENCODE( pMainDialog->m_hAudioMP2EncoderDev, g_p_audio_frame_buffer_background, g_n_audio_frame_length_background, &pStreamBuffer, &nStreamBufferSize, g_n_src_audio_sample_time, &n_dst_sample_time );

				if( pStreamBuffer != NULL && nStreamBufferSize > 0 ) 
				{
					AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( pMainDialog->m_hFileRendererDev, pStreamBuffer, nStreamBufferSize, 0, n_dst_sample_time );
				}
			}
		}
	}

	return 0;
}

BOOL on_process_preview_video_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CRecordTSDlg *  pMainDialog = (CRecordTSDlg *)(pUserData);
	
	if( pMainDialog->m_nFileRendererRecordState >= 0x00000001 )
	{
		if ( pBuffer != NULL && nBufferLen > 0 )
		{
			g_p_video_frame_buffer_background = pBuffer;

			g_n_video_frame_length_background = nBufferLen;		

			g_n_src_video_sample_time = (ULONGLONG)(dSampleTime * 10000000);

			if(  pMainDialog->m_hVideoThreadBufferReadyEvent )
			{
				SetEvent( pMainDialog->m_hVideoThreadBufferReadyEvent );
			}		
		}
	}

	return TRUE;
}

BOOL on_process_audio_buffer_ex( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CRecordTSDlg *  pMainDialog = (CRecordTSDlg *)(pUserData);	

	if( pMainDialog->m_nFileRendererRecordState >= 0x00000002 )
	{
		if ( pBuffer != NULL && nBufferLen > 0 )
		{
			g_p_audio_frame_buffer_background = pBuffer;

			g_n_audio_frame_length_background = nBufferLen;		

			g_n_src_audio_sample_time = (ULONGLONG)(dSampleTime * 10000000);

			if(  pMainDialog->m_hAudioThreadBufferReadyEvent )
			{
				SetEvent( pMainDialog->m_hAudioThreadBufferReadyEvent );
			}		
		}
	}

	return TRUE;
}

BOOL on_process_audio_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	BOOL returns = on_process_audio_buffer_ex( dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData );

	return returns;
}

// CRecordTSDlg dialog


CRecordTSDlg::CRecordTSDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CRecordTSDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_bSetBuffer = FALSE;

	m_hVideoDev = 0xFFFFFFFF;

	m_hVideoSWEncoderDev = 0xFFFFFFFF;

	m_hAudioDev = 0xFFFFFFFF;

	m_hAudioMP2EncoderDev = 0xFFFFFFFF;

	m_hFileRendererDev = 0xFFFFFFFF;

	m_nFileRendererRecordState = 0x00000000;

	m_hVideoThreadBufferReadyEvent = NULL;

	m_hVideoThread = NULL;	

	m_hVideoThreadNumber = 0;

	m_hAudioThreadBufferReadyEvent = NULL;

	m_hAudioThread = NULL;	

	m_hAudioThreadNumber = 0;
}

void CRecordTSDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRecordTSDlg)
	DDX_Control(pDX, IDC_STATIC_WINDOW, m_statWindow);
	DDX_Control(pDX, IDC_BTN_START, m_btnStart);
	DDX_Control(pDX, IDC_BTN_STOP, m_btnStop);
	//}}AFX_DATA_MAP	
}

BEGIN_MESSAGE_MAP(CRecordTSDlg, CDialogEx)
	//{{AFX_MSG_MAP(CRecordTSDlg)
	ON_WM_PAINT()
	ON_WM_DESTROY()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_START, &CRecordTSDlg::OnBnClickedBtnStart)
	ON_BN_CLICKED(IDC_BTN_STOP, &CRecordTSDlg::OnBnClickedBtnStop)
END_MESSAGE_MAP()


// CRecordTSDlg message handlers

BOOL CRecordTSDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );

	CenterWindow();

	CString strCaption;

	strCaption.Format( "Yuan's %s Demo Software - TS RECORD ", PRODUCT_NAME );

	SetWindowText( strCaption );

	HwInitialize();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CRecordTSDlg::OnDestroy() 
{
	OnBnClickedBtnStop();

	HwUnInitialize();

	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();
}

BOOL CRecordTSDlg::HwInitialize()
{
	PF_BUFFER_CALLBACK	pfVideoPreviewBC = NULL;

	PF_BUFFER_CALLBACK	pfAudioPreviewBC = NULL;

	pfVideoPreviewBC = on_process_preview_video_buffer;

	pfAudioPreviewBC = on_process_audio_buffer;

	CWnd *pPreviewWnd = GetDlgItem( IDC_STATIC_WINDOW );

	m_hVideoDev = AMESDK_CREATE_EX( CHIP_NAME, 0, 0, pPreviewWnd->GetSafeHwnd(), pfVideoPreviewBC, FALSE, TRUE, TRUE, this );	

	if( m_hVideoDev & 0x80000000 ) 
	{ 
		m_hVideoDev = 0xFFFFFFFF; 

		return FALSE; 		
	}

	m_hAudioDev = AMESDK_CREATE( AUDIO_CHIP_NAME, 0, 0, pPreviewWnd->GetSafeHwnd(), pfAudioPreviewBC, this );

	if( m_hAudioDev & 0x80000000 ) 
	{ 
		m_hAudioDev = 0xFFFFFFFF; 

		return FALSE;
	}

	// INTEL ENCODER
	//
	//m_hVideoSWEncoderDev = AMESDK_CREATE( "Common Analog Intel Encoder (MPEG2)", 0, 7, NULL, NULL, NULL );

	// SOFTWARE ENCODER
	//
	m_hVideoSWEncoderDev = AMESDK_CREATE( "Common Analog Encoder (MPEG2)", 0, 7, NULL, NULL, NULL );

	if( m_hVideoSWEncoderDev & 0x80000000 ) 
	{ 
		m_hVideoSWEncoderDev = 0xFFFFFFFF; 

		return FALSE; 		
	}

	m_hAudioMP2EncoderDev = AMESDK_CREATE( "Common Analog Encoder (MP2)", 0, 7, NULL, NULL, NULL );

	if( m_hAudioMP2EncoderDev & 0x80000000 ) 
	{ 
		m_hAudioMP2EncoderDev = 0xFFFFFFFF; 

		return FALSE; 		
	}	

	// SETUP LIVE PATH PROPERTIES
	// 		
	AMESDK_SET_STANDARD( m_hVideoDev, NTSC );
	
	AMESDK_SET_FORMAT( m_hVideoDev, PREVIEW_COLORSPACE, WIDTH, HEIGHT, PREVIEW_BIT_COUNT, FPS );

	AMESDK_SET_INPUT( m_hVideoDev, SDI_INPUT );

	// SETUP SOFTWARE ENCODER PROPERTIES
	//
	AMESDK_SET_FORMAT( m_hVideoSWEncoderDev, ENCODER_COLORSPACE, WIDTH, HEIGHT, ENCODER_BIT_COUNT, FPS, ENCODER_MODE, ENCODER_BITRATE, ENCODER_QUALITY, ENCODER_GOP,  FALSE, 0 ); // RESOLUTION / FRAMERATE / RECORD MODE / BITRATE (CBR) / QULAITY (VBR) / GOP / INTERLACE MODE

	// SETUP AUDIO PATH (MP2) PROPERTIES
	//
	AMESDK_SET_FORMAT( m_hAudioDev, 2, 16, 48000 );

	AMESDK_SET_FORMAT( m_hAudioMP2EncoderDev, 2, 16, 48000 );

	AMESDK_SET_VOLUME( m_hAudioDev, 100 );

	AMESDK_RUN( m_hVideoDev );

	AMESDK_RUN( m_hAudioDev );

	AMESDK_RUN( m_hVideoSWEncoderDev );

	AMESDK_RUN( m_hAudioMP2EncoderDev );

	m_hVideoThreadBufferReadyEvent = CreateEvent( NULL, FALSE, FALSE, NULL );	

	m_hVideoThread = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)( on_push_video_framebuffer ), (LPVOID)(this), CREATE_SUSPENDED, &m_hVideoThreadNumber );

	m_hAudioThreadBufferReadyEvent = CreateEvent( NULL, FALSE, FALSE, NULL );

	m_hAudioThread = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)( on_push_audio_framebuffer ), (LPVOID)(this), CREATE_SUSPENDED, &m_hAudioThreadNumber );

	m_bSetBuffer = TRUE;

	ResumeThread( m_hVideoThread );

	ResumeThread( m_hAudioThread );

	return TRUE;
}

BOOL CRecordTSDlg::HwUnInitialize()
{
	m_bSetBuffer = FALSE;

	Sleep( 100 );

	if ( m_hVideoThreadBufferReadyEvent )
	{
		ResetEvent( m_hVideoThreadBufferReadyEvent );

		CloseHandle( m_hVideoThreadBufferReadyEvent );	

		m_hVideoThreadBufferReadyEvent = NULL;
	}

	if ( m_hAudioThreadBufferReadyEvent )
	{
		ResetEvent( m_hAudioThreadBufferReadyEvent );

		CloseHandle( m_hAudioThreadBufferReadyEvent );	

		m_hAudioThreadBufferReadyEvent = NULL;
	}

	TERMINATE_THREAD( m_hVideoThread );

	TERMINATE_THREAD( m_hAudioThread );

	if( m_hVideoDev != 0xFFFFFFFF ) 
	{ 
		AMESDK_STOP( m_hVideoDev );

		AMESDK_DESTROY( m_hVideoDev );
		
		m_hVideoDev = 0xFFFFFFFF; 
	}

	if( m_hAudioDev != 0xFFFFFFFF ) 
	{ 
		AMESDK_STOP( m_hAudioDev );

		AMESDK_DESTROY( m_hAudioDev );
		
		m_hAudioDev = 0xFFFFFFFF; 
	}

	if( m_hVideoSWEncoderDev != 0xFFFFFFFF ) 
	{
		AMESDK_DESTROY( m_hVideoSWEncoderDev );
		
		m_hVideoSWEncoderDev = 0xFFFFFFFF; 
	}

	if( m_hAudioMP2EncoderDev != 0xFFFFFFFF ) 
	{
		AMESDK_DESTROY( m_hAudioMP2EncoderDev );
		
		m_hAudioMP2EncoderDev = 0xFFFFFFFF; 
	}

	if( m_hFileRendererDev != 0xFFFFFFFF ) 
	{
		AMESDK_DESTROY( m_hFileRendererDev );
		
		m_hFileRendererDev = 0xFFFFFFFF; 
	}

	return TRUE;
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CRecordTSDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CRecordTSDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

CString CRecordTSDlg::GetWorkingPath()
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	return strCurPath;
}

void CRecordTSDlg::OnBnClickedBtnStart()
{
	// TODO: Add your control notification handler code here

	m_btnStart.EnableWindow( FALSE );

	m_btnStop.EnableWindow( TRUE );

	CHAR szFilePath[ MAX_PATH ] = { 0 };

	sprintf( szFilePath, "Common Analog File Renderer %sH264_AAC_%d_%d_%.2f.TS", GetWorkingPath(), WIDTH, HEIGHT, FPS );

	m_hFileRendererDev = AMESDK_CREATE( szFilePath, 0, 3, NULL, NULL, NULL );

	if( m_hFileRendererDev & 0x80000000 )
	{				
		m_hFileRendererDev = 0xFFFFFFFF;
	}

	AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hFileRendererDev, ENCODER_COLORSPACE, WIDTH, HEIGHT, ENCODER_BIT_COUNT, FPS, AMESDK_FILE_CUSTOMFLAG_NONINDEX | AMESDK_FILE_CUSTOMFLAG_ISSYNCHRONIZATION );

	AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hFileRendererDev, 0x00000004, 2, 16, 48000 ); // MP2 / STEREO / BITS / HZ

	m_nFileRendererRecordState = 0x00000001;	
}


void CRecordTSDlg::OnBnClickedBtnStop()
{
	// TODO: Add your control notification handler code here

	m_nFileRendererRecordState= 0x00000000;

	Sleep( 100 );

	m_btnStart.EnableWindow( TRUE );

	m_btnStop.EnableWindow( FALSE );

	if( m_hFileRendererDev != 0xFFFFFFFF )
	{ 					
		AMESDK_DESTROY( m_hFileRendererDev ); 
		
		m_hFileRendererDev = 0xFFFFFFFF;	
	}
}
